function [x,ind,e,k]=prank(C,alfa,TOL,kmax)
%PRANK pagerank.
%   [x,ind,e,k]=PRANK(C,alfa,TOL,kmax) calcola il pagerank x associato
%   alla matrice di connettivita' C (sparsa) a meno di una tolleranza TOL e 
%   con numero massimo di iterazioni kmax per il metodo delle potenze.  
%   ind e' il vettore degli indici delle pagine web relative a C ordinato 
%   secondo il pagerank x, e e' la stima dell'errore finale e k il numero 
%   di iterazioni eseguite.

%0 verifica di sparsita'
if not(issparse(C))
    disp('ATTENZIONE: la matrice di connettivita'' non e'' sparsa!')
    return
end
%1: inizializzazione
n=size(C,1);%numero pagine web
u=ones(n,1);%vettore unitario
c=sum(C,1); %numero outlink
%2: costruzione matrice di connettivita' normalizzata H
H=sparse(n,n);
for j=1:n
    if c(j)~=0
        H(:,j)=C(:,j)/c(j);
    end
end
%3: costruzione vettore pagine penzolanti
d=not(sum(H,1))';
%4: costruzione matrice H1 (non serve per il calcolo!!)
H1=H+(u*d')/n;
%5: costruzione 'google matrix' H2 (non serve per il calcolo!!)
H2=alfa*H1+(1-alfa)*(u*u')/n;
%6: metodo potenze per calcolo pagerank x
k=0;
xnew=u/n;
e=TOL+1;
while (e>=TOL)&(k<=kmax)
    k=k+1;
    xold=xnew;
    xnew=alfa*H*xold+u/n*(alfa*d'*xold+1-alfa);
    e=norm(xnew-xold);
end
%4: output ordinato secondo pagerank x
[x,ind]=sort(xnew,'descend');

%NB: i comandi tipo 'sparse' servono a non tener conto degli zeri nei 
%   calcoli. Ad esempio H=sparse(n,n) crea una matrice nxn di tutti zeri 
%   ma la memorizza come sparsa: quando viene modificata nelle successive 
%   istruzioni, gli zeri che rimangono non saranno comunque considerati
%   nei calcoli.