function out = SteLar

out{1} = @init;
out{2} = @fun_eval;
out{3} = @jacobian;
out{4} = @jacobianp;
out{5} = @hessians;
out{6} = @hessiansp;
out{7} = @der3;
out{8} = @der4;
out{9} = @der5;

% --------------------------------------------------------------------------
function dydt = fun_eval(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
dydt=[-k1*kmrgd(1)*kmrgd(2)*kmrgd(3)-k3*kmrgd(1)*kmrgd(2)*kmrgd(4)+k7-km7*kmrgd(1);
-k1*kmrgd(1)*kmrgd(2)*kmrgd(3)-k3*kmrgd(1)*kmrgd(2)*kmrgd(4)+k8;
k1*kmrgd(1)*kmrgd(2)*kmrgd(3)-2*k2*kmrgd(3)^2+2*k3*kmrgd(1)*kmrgd(2)*kmrgd(4)-k4*kmrgd(3)+k6;
-k3*kmrgd(1)*kmrgd(2)*kmrgd(4)+2*k2*kmrgd(3)^2-k5*kmrgd(4);];

% --------------------------------------------------------------------------
function [tspan,y0,options] = init
handles = feval(SteLar);
y0=[0,0,0,0];
options = odeset('Jacobian',handles(3),'JacobianP',handles(4),'Hessians',handles(5),'HessiansP',handles(6));
tspan = [0 10];

% --------------------------------------------------------------------------
function jac = jacobian(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
jac=[ - km7 - kmrgd(2)*kmrgd(3)*k1 - kmrgd(2)*kmrgd(4)*k3 , - kmrgd(1)*kmrgd(3)*k1 - kmrgd(1)*kmrgd(4)*k3 , -kmrgd(1)*kmrgd(2)*k1 , -kmrgd(1)*kmrgd(2)*k3 ; - kmrgd(2)*kmrgd(3)*k1 - kmrgd(2)*kmrgd(4)*k3 , - kmrgd(1)*kmrgd(3)*k1 - kmrgd(1)*kmrgd(4)*k3 , -kmrgd(1)*kmrgd(2)*k1 , -kmrgd(1)*kmrgd(2)*k3 ; kmrgd(2)*kmrgd(3)*k1 + 2*kmrgd(2)*kmrgd(4)*k3 , kmrgd(1)*kmrgd(3)*k1 + 2*kmrgd(1)*kmrgd(4)*k3 , kmrgd(1)*kmrgd(2)*k1 - 4*kmrgd(3)*k2 - k4 , 2*kmrgd(1)*kmrgd(2)*k3 ; -kmrgd(2)*kmrgd(4)*k3 , -kmrgd(1)*kmrgd(4)*k3 , 4*kmrgd(3)*k2 , - k5 - kmrgd(1)*kmrgd(2)*k3 ];
% --------------------------------------------------------------------------
function jacp = jacobianp(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
jacp=[ -kmrgd(1)*kmrgd(2)*kmrgd(3) , 0 , -kmrgd(1)*kmrgd(2)*kmrgd(4) , 0 , 0 , 0 , 1 , -kmrgd(1) , 0 ; -kmrgd(1)*kmrgd(2)*kmrgd(3) , 0 , -kmrgd(1)*kmrgd(2)*kmrgd(4) , 0 , 0 , 0 , 0 , 0 , 1 ; kmrgd(1)*kmrgd(2)*kmrgd(3) , -2*kmrgd(3)^2 , 2*kmrgd(1)*kmrgd(2)*kmrgd(4) , -kmrgd(3) , 0 , 1 , 0 , 0 , 0 ; 0 , 2*kmrgd(3)^2 , -kmrgd(1)*kmrgd(2)*kmrgd(4) , 0 , -kmrgd(4) , 0 , 0 , 0 , 0 ];
% --------------------------------------------------------------------------
function hess = hessians(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
hess1=[ 0 , - kmrgd(3)*k1 - kmrgd(4)*k3 , -kmrgd(2)*k1 , -kmrgd(2)*k3 ; 0 , - kmrgd(3)*k1 - kmrgd(4)*k3 , -kmrgd(2)*k1 , -kmrgd(2)*k3 ; 0 , kmrgd(3)*k1 + 2*kmrgd(4)*k3 , kmrgd(2)*k1 , 2*kmrgd(2)*k3 ; 0 , -kmrgd(4)*k3 , 0 , -kmrgd(2)*k3 ];
hess2=[ - kmrgd(3)*k1 - kmrgd(4)*k3 , 0 , -kmrgd(1)*k1 , -kmrgd(1)*k3 ; - kmrgd(3)*k1 - kmrgd(4)*k3 , 0 , -kmrgd(1)*k1 , -kmrgd(1)*k3 ; kmrgd(3)*k1 + 2*kmrgd(4)*k3 , 0 , kmrgd(1)*k1 , 2*kmrgd(1)*k3 ; -kmrgd(4)*k3 , 0 , 0 , -kmrgd(1)*k3 ];
hess3=[ -kmrgd(2)*k1 , -kmrgd(1)*k1 , 0 , 0 ; -kmrgd(2)*k1 , -kmrgd(1)*k1 , 0 , 0 ; kmrgd(2)*k1 , kmrgd(1)*k1 , -4*k2 , 0 ; 0 , 0 , 4*k2 , 0 ];
hess4=[ -kmrgd(2)*k3 , -kmrgd(1)*k3 , 0 , 0 ; -kmrgd(2)*k3 , -kmrgd(1)*k3 , 0 , 0 ; 2*kmrgd(2)*k3 , 2*kmrgd(1)*k3 , 0 , 0 ; -kmrgd(2)*k3 , -kmrgd(1)*k3 , 0 , 0 ];
hess(:,:,1) =hess1;
hess(:,:,2) =hess2;
hess(:,:,3) =hess3;
hess(:,:,4) =hess4;
% --------------------------------------------------------------------------
function hessp = hessiansp(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
hessp1=[ -kmrgd(2)*kmrgd(3) , -kmrgd(1)*kmrgd(3) , -kmrgd(1)*kmrgd(2) , 0 ; -kmrgd(2)*kmrgd(3) , -kmrgd(1)*kmrgd(3) , -kmrgd(1)*kmrgd(2) , 0 ; kmrgd(2)*kmrgd(3) , kmrgd(1)*kmrgd(3) , kmrgd(1)*kmrgd(2) , 0 ; 0 , 0 , 0 , 0 ];
hessp2=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , -4*kmrgd(3) , 0 ; 0 , 0 , 4*kmrgd(3) , 0 ];
hessp3=[ -kmrgd(2)*kmrgd(4) , -kmrgd(1)*kmrgd(4) , 0 , -kmrgd(1)*kmrgd(2) ; -kmrgd(2)*kmrgd(4) , -kmrgd(1)*kmrgd(4) , 0 , -kmrgd(1)*kmrgd(2) ; 2*kmrgd(2)*kmrgd(4) , 2*kmrgd(1)*kmrgd(4) , 0 , 2*kmrgd(1)*kmrgd(2) ; -kmrgd(2)*kmrgd(4) , -kmrgd(1)*kmrgd(4) , 0 , -kmrgd(1)*kmrgd(2) ];
hessp4=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , -1 , 0 ; 0 , 0 , 0 , 0 ];
hessp5=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , -1 ];
hessp6=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
hessp7=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
hessp8=[ -1 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
hessp9=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
hessp(:,:,1) =hessp1;
hessp(:,:,2) =hessp2;
hessp(:,:,3) =hessp3;
hessp(:,:,4) =hessp4;
hessp(:,:,5) =hessp5;
hessp(:,:,6) =hessp6;
hessp(:,:,7) =hessp7;
hessp(:,:,8) =hessp8;
hessp(:,:,9) =hessp9;
%---------------------------------------------------------------------------
function tens3  = der3(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
tens31=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens32=[ 0 , 0 , -k1 , -k3 ; 0 , 0 , -k1 , -k3 ; 0 , 0 , k1 , 2*k3 ; 0 , 0 , 0 , -k3 ];
tens33=[ 0 , -k1 , 0 , 0 ; 0 , -k1 , 0 , 0 ; 0 , k1 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens34=[ 0 , -k3 , 0 , 0 ; 0 , -k3 , 0 , 0 ; 0 , 2*k3 , 0 , 0 ; 0 , -k3 , 0 , 0 ];
tens35=[ 0 , 0 , -k1 , -k3 ; 0 , 0 , -k1 , -k3 ; 0 , 0 , k1 , 2*k3 ; 0 , 0 , 0 , -k3 ];
tens36=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens37=[ -k1 , 0 , 0 , 0 ; -k1 , 0 , 0 , 0 ; k1 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens38=[ -k3 , 0 , 0 , 0 ; -k3 , 0 , 0 , 0 ; 2*k3 , 0 , 0 , 0 ; -k3 , 0 , 0 , 0 ];
tens39=[ 0 , -k1 , 0 , 0 ; 0 , -k1 , 0 , 0 ; 0 , k1 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens310=[ -k1 , 0 , 0 , 0 ; -k1 , 0 , 0 , 0 ; k1 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens311=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens312=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens313=[ 0 , -k3 , 0 , 0 ; 0 , -k3 , 0 , 0 ; 0 , 2*k3 , 0 , 0 ; 0 , -k3 , 0 , 0 ];
tens314=[ -k3 , 0 , 0 , 0 ; -k3 , 0 , 0 , 0 ; 2*k3 , 0 , 0 , 0 ; -k3 , 0 , 0 , 0 ];
tens315=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens316=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens3(:,:,1,1) =tens31;
tens3(:,:,1,2) =tens32;
tens3(:,:,1,3) =tens33;
tens3(:,:,1,4) =tens34;
tens3(:,:,2,1) =tens35;
tens3(:,:,2,2) =tens36;
tens3(:,:,2,3) =tens37;
tens3(:,:,2,4) =tens38;
tens3(:,:,3,1) =tens39;
tens3(:,:,3,2) =tens310;
tens3(:,:,3,3) =tens311;
tens3(:,:,3,4) =tens312;
tens3(:,:,4,1) =tens313;
tens3(:,:,4,2) =tens314;
tens3(:,:,4,3) =tens315;
tens3(:,:,4,4) =tens316;
%---------------------------------------------------------------------------
function tens4  = der4(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
tens41=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens42=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens43=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens44=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens45=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens46=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens47=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens48=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens49=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens410=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens411=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens412=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens413=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens414=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens415=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens416=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens417=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens418=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens419=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens420=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens421=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens422=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens423=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens424=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens425=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens426=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens427=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens428=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens429=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens430=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens431=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens432=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens433=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens434=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens435=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens436=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens437=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens438=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens439=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens440=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens441=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens442=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens443=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens444=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens445=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens446=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens447=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens448=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens449=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens450=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens451=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens452=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens453=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens454=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens455=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens456=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens457=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens458=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens459=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens460=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens461=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens462=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens463=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens464=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens4(:,:,1,1,1) =tens41;
tens4(:,:,1,1,2) =tens42;
tens4(:,:,1,1,3) =tens43;
tens4(:,:,1,1,4) =tens44;
tens4(:,:,1,2,1) =tens45;
tens4(:,:,1,2,2) =tens46;
tens4(:,:,1,2,3) =tens47;
tens4(:,:,1,2,4) =tens48;
tens4(:,:,1,3,1) =tens49;
tens4(:,:,1,3,2) =tens410;
tens4(:,:,1,3,3) =tens411;
tens4(:,:,1,3,4) =tens412;
tens4(:,:,1,4,1) =tens413;
tens4(:,:,1,4,2) =tens414;
tens4(:,:,1,4,3) =tens415;
tens4(:,:,1,4,4) =tens416;
tens4(:,:,2,1,1) =tens417;
tens4(:,:,2,1,2) =tens418;
tens4(:,:,2,1,3) =tens419;
tens4(:,:,2,1,4) =tens420;
tens4(:,:,2,2,1) =tens421;
tens4(:,:,2,2,2) =tens422;
tens4(:,:,2,2,3) =tens423;
tens4(:,:,2,2,4) =tens424;
tens4(:,:,2,3,1) =tens425;
tens4(:,:,2,3,2) =tens426;
tens4(:,:,2,3,3) =tens427;
tens4(:,:,2,3,4) =tens428;
tens4(:,:,2,4,1) =tens429;
tens4(:,:,2,4,2) =tens430;
tens4(:,:,2,4,3) =tens431;
tens4(:,:,2,4,4) =tens432;
tens4(:,:,3,1,1) =tens433;
tens4(:,:,3,1,2) =tens434;
tens4(:,:,3,1,3) =tens435;
tens4(:,:,3,1,4) =tens436;
tens4(:,:,3,2,1) =tens437;
tens4(:,:,3,2,2) =tens438;
tens4(:,:,3,2,3) =tens439;
tens4(:,:,3,2,4) =tens440;
tens4(:,:,3,3,1) =tens441;
tens4(:,:,3,3,2) =tens442;
tens4(:,:,3,3,3) =tens443;
tens4(:,:,3,3,4) =tens444;
tens4(:,:,3,4,1) =tens445;
tens4(:,:,3,4,2) =tens446;
tens4(:,:,3,4,3) =tens447;
tens4(:,:,3,4,4) =tens448;
tens4(:,:,4,1,1) =tens449;
tens4(:,:,4,1,2) =tens450;
tens4(:,:,4,1,3) =tens451;
tens4(:,:,4,1,4) =tens452;
tens4(:,:,4,2,1) =tens453;
tens4(:,:,4,2,2) =tens454;
tens4(:,:,4,2,3) =tens455;
tens4(:,:,4,2,4) =tens456;
tens4(:,:,4,3,1) =tens457;
tens4(:,:,4,3,2) =tens458;
tens4(:,:,4,3,3) =tens459;
tens4(:,:,4,3,4) =tens460;
tens4(:,:,4,4,1) =tens461;
tens4(:,:,4,4,2) =tens462;
tens4(:,:,4,4,3) =tens463;
tens4(:,:,4,4,4) =tens464;
%---------------------------------------------------------------------------
function tens5  = der5(t,kmrgd,k1,k2,k3,k4,k5,k6,k7,km7,k8)
tens51=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens52=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens53=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens54=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens55=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens56=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens57=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens58=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens59=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens510=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens511=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens512=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens513=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens514=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens515=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens516=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens517=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens518=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens519=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens520=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens521=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens522=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens523=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens524=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens525=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens526=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens527=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens528=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens529=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens530=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens531=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens532=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens533=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens534=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens535=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens536=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens537=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens538=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens539=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens540=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens541=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens542=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens543=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens544=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens545=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens546=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens547=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens548=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens549=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens550=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens551=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens552=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens553=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens554=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens555=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens556=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens557=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens558=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens559=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens560=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens561=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens562=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens563=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens564=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens565=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens566=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens567=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens568=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens569=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens570=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens571=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens572=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens573=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens574=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens575=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens576=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens577=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens578=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens579=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens580=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens581=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens582=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens583=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens584=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens585=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens586=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens587=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens588=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens589=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens590=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens591=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens592=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens593=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens594=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens595=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens596=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens597=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens598=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens599=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5100=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5101=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5102=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5103=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5104=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5105=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5106=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5107=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5108=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5109=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5110=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5111=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5112=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5113=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5114=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5115=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5116=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5117=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5118=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5119=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5120=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5121=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5122=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5123=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5124=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5125=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5126=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5127=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5128=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5129=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5130=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5131=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5132=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5133=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5134=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5135=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5136=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5137=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5138=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5139=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5140=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5141=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5142=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5143=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5144=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5145=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5146=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5147=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5148=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5149=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5150=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5151=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5152=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5153=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5154=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5155=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5156=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5157=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5158=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5159=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5160=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5161=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5162=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5163=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5164=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5165=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5166=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5167=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5168=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5169=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5170=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5171=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5172=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5173=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5174=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5175=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5176=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5177=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5178=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5179=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5180=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5181=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5182=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5183=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5184=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5185=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5186=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5187=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5188=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5189=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5190=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5191=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5192=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5193=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5194=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5195=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5196=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5197=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5198=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5199=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5200=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5201=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5202=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5203=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5204=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5205=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5206=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5207=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5208=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5209=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5210=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5211=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5212=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5213=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5214=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5215=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5216=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5217=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5218=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5219=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5220=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5221=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5222=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5223=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5224=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5225=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5226=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5227=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5228=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5229=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5230=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5231=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5232=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5233=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5234=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5235=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5236=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5237=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5238=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5239=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5240=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5241=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5242=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5243=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5244=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5245=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5246=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5247=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5248=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5249=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5250=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5251=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5252=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5253=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5254=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5255=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5256=[ 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 ];
tens5(:,:,1,1,1,1) =tens51;
tens5(:,:,1,1,1,2) =tens52;
tens5(:,:,1,1,1,3) =tens53;
tens5(:,:,1,1,1,4) =tens54;
tens5(:,:,1,1,2,1) =tens55;
tens5(:,:,1,1,2,2) =tens56;
tens5(:,:,1,1,2,3) =tens57;
tens5(:,:,1,1,2,4) =tens58;
tens5(:,:,1,1,3,1) =tens59;
tens5(:,:,1,1,3,2) =tens510;
tens5(:,:,1,1,3,3) =tens511;
tens5(:,:,1,1,3,4) =tens512;
tens5(:,:,1,1,4,1) =tens513;
tens5(:,:,1,1,4,2) =tens514;
tens5(:,:,1,1,4,3) =tens515;
tens5(:,:,1,1,4,4) =tens516;
tens5(:,:,1,2,1,1) =tens517;
tens5(:,:,1,2,1,2) =tens518;
tens5(:,:,1,2,1,3) =tens519;
tens5(:,:,1,2,1,4) =tens520;
tens5(:,:,1,2,2,1) =tens521;
tens5(:,:,1,2,2,2) =tens522;
tens5(:,:,1,2,2,3) =tens523;
tens5(:,:,1,2,2,4) =tens524;
tens5(:,:,1,2,3,1) =tens525;
tens5(:,:,1,2,3,2) =tens526;
tens5(:,:,1,2,3,3) =tens527;
tens5(:,:,1,2,3,4) =tens528;
tens5(:,:,1,2,4,1) =tens529;
tens5(:,:,1,2,4,2) =tens530;
tens5(:,:,1,2,4,3) =tens531;
tens5(:,:,1,2,4,4) =tens532;
tens5(:,:,1,3,1,1) =tens533;
tens5(:,:,1,3,1,2) =tens534;
tens5(:,:,1,3,1,3) =tens535;
tens5(:,:,1,3,1,4) =tens536;
tens5(:,:,1,3,2,1) =tens537;
tens5(:,:,1,3,2,2) =tens538;
tens5(:,:,1,3,2,3) =tens539;
tens5(:,:,1,3,2,4) =tens540;
tens5(:,:,1,3,3,1) =tens541;
tens5(:,:,1,3,3,2) =tens542;
tens5(:,:,1,3,3,3) =tens543;
tens5(:,:,1,3,3,4) =tens544;
tens5(:,:,1,3,4,1) =tens545;
tens5(:,:,1,3,4,2) =tens546;
tens5(:,:,1,3,4,3) =tens547;
tens5(:,:,1,3,4,4) =tens548;
tens5(:,:,1,4,1,1) =tens549;
tens5(:,:,1,4,1,2) =tens550;
tens5(:,:,1,4,1,3) =tens551;
tens5(:,:,1,4,1,4) =tens552;
tens5(:,:,1,4,2,1) =tens553;
tens5(:,:,1,4,2,2) =tens554;
tens5(:,:,1,4,2,3) =tens555;
tens5(:,:,1,4,2,4) =tens556;
tens5(:,:,1,4,3,1) =tens557;
tens5(:,:,1,4,3,2) =tens558;
tens5(:,:,1,4,3,3) =tens559;
tens5(:,:,1,4,3,4) =tens560;
tens5(:,:,1,4,4,1) =tens561;
tens5(:,:,1,4,4,2) =tens562;
tens5(:,:,1,4,4,3) =tens563;
tens5(:,:,1,4,4,4) =tens564;
tens5(:,:,2,1,1,1) =tens565;
tens5(:,:,2,1,1,2) =tens566;
tens5(:,:,2,1,1,3) =tens567;
tens5(:,:,2,1,1,4) =tens568;
tens5(:,:,2,1,2,1) =tens569;
tens5(:,:,2,1,2,2) =tens570;
tens5(:,:,2,1,2,3) =tens571;
tens5(:,:,2,1,2,4) =tens572;
tens5(:,:,2,1,3,1) =tens573;
tens5(:,:,2,1,3,2) =tens574;
tens5(:,:,2,1,3,3) =tens575;
tens5(:,:,2,1,3,4) =tens576;
tens5(:,:,2,1,4,1) =tens577;
tens5(:,:,2,1,4,2) =tens578;
tens5(:,:,2,1,4,3) =tens579;
tens5(:,:,2,1,4,4) =tens580;
tens5(:,:,2,2,1,1) =tens581;
tens5(:,:,2,2,1,2) =tens582;
tens5(:,:,2,2,1,3) =tens583;
tens5(:,:,2,2,1,4) =tens584;
tens5(:,:,2,2,2,1) =tens585;
tens5(:,:,2,2,2,2) =tens586;
tens5(:,:,2,2,2,3) =tens587;
tens5(:,:,2,2,2,4) =tens588;
tens5(:,:,2,2,3,1) =tens589;
tens5(:,:,2,2,3,2) =tens590;
tens5(:,:,2,2,3,3) =tens591;
tens5(:,:,2,2,3,4) =tens592;
tens5(:,:,2,2,4,1) =tens593;
tens5(:,:,2,2,4,2) =tens594;
tens5(:,:,2,2,4,3) =tens595;
tens5(:,:,2,2,4,4) =tens596;
tens5(:,:,2,3,1,1) =tens597;
tens5(:,:,2,3,1,2) =tens598;
tens5(:,:,2,3,1,3) =tens599;
tens5(:,:,2,3,1,4) =tens5100;
tens5(:,:,2,3,2,1) =tens5101;
tens5(:,:,2,3,2,2) =tens5102;
tens5(:,:,2,3,2,3) =tens5103;
tens5(:,:,2,3,2,4) =tens5104;
tens5(:,:,2,3,3,1) =tens5105;
tens5(:,:,2,3,3,2) =tens5106;
tens5(:,:,2,3,3,3) =tens5107;
tens5(:,:,2,3,3,4) =tens5108;
tens5(:,:,2,3,4,1) =tens5109;
tens5(:,:,2,3,4,2) =tens5110;
tens5(:,:,2,3,4,3) =tens5111;
tens5(:,:,2,3,4,4) =tens5112;
tens5(:,:,2,4,1,1) =tens5113;
tens5(:,:,2,4,1,2) =tens5114;
tens5(:,:,2,4,1,3) =tens5115;
tens5(:,:,2,4,1,4) =tens5116;
tens5(:,:,2,4,2,1) =tens5117;
tens5(:,:,2,4,2,2) =tens5118;
tens5(:,:,2,4,2,3) =tens5119;
tens5(:,:,2,4,2,4) =tens5120;
tens5(:,:,2,4,3,1) =tens5121;
tens5(:,:,2,4,3,2) =tens5122;
tens5(:,:,2,4,3,3) =tens5123;
tens5(:,:,2,4,3,4) =tens5124;
tens5(:,:,2,4,4,1) =tens5125;
tens5(:,:,2,4,4,2) =tens5126;
tens5(:,:,2,4,4,3) =tens5127;
tens5(:,:,2,4,4,4) =tens5128;
tens5(:,:,3,1,1,1) =tens5129;
tens5(:,:,3,1,1,2) =tens5130;
tens5(:,:,3,1,1,3) =tens5131;
tens5(:,:,3,1,1,4) =tens5132;
tens5(:,:,3,1,2,1) =tens5133;
tens5(:,:,3,1,2,2) =tens5134;
tens5(:,:,3,1,2,3) =tens5135;
tens5(:,:,3,1,2,4) =tens5136;
tens5(:,:,3,1,3,1) =tens5137;
tens5(:,:,3,1,3,2) =tens5138;
tens5(:,:,3,1,3,3) =tens5139;
tens5(:,:,3,1,3,4) =tens5140;
tens5(:,:,3,1,4,1) =tens5141;
tens5(:,:,3,1,4,2) =tens5142;
tens5(:,:,3,1,4,3) =tens5143;
tens5(:,:,3,1,4,4) =tens5144;
tens5(:,:,3,2,1,1) =tens5145;
tens5(:,:,3,2,1,2) =tens5146;
tens5(:,:,3,2,1,3) =tens5147;
tens5(:,:,3,2,1,4) =tens5148;
tens5(:,:,3,2,2,1) =tens5149;
tens5(:,:,3,2,2,2) =tens5150;
tens5(:,:,3,2,2,3) =tens5151;
tens5(:,:,3,2,2,4) =tens5152;
tens5(:,:,3,2,3,1) =tens5153;
tens5(:,:,3,2,3,2) =tens5154;
tens5(:,:,3,2,3,3) =tens5155;
tens5(:,:,3,2,3,4) =tens5156;
tens5(:,:,3,2,4,1) =tens5157;
tens5(:,:,3,2,4,2) =tens5158;
tens5(:,:,3,2,4,3) =tens5159;
tens5(:,:,3,2,4,4) =tens5160;
tens5(:,:,3,3,1,1) =tens5161;
tens5(:,:,3,3,1,2) =tens5162;
tens5(:,:,3,3,1,3) =tens5163;
tens5(:,:,3,3,1,4) =tens5164;
tens5(:,:,3,3,2,1) =tens5165;
tens5(:,:,3,3,2,2) =tens5166;
tens5(:,:,3,3,2,3) =tens5167;
tens5(:,:,3,3,2,4) =tens5168;
tens5(:,:,3,3,3,1) =tens5169;
tens5(:,:,3,3,3,2) =tens5170;
tens5(:,:,3,3,3,3) =tens5171;
tens5(:,:,3,3,3,4) =tens5172;
tens5(:,:,3,3,4,1) =tens5173;
tens5(:,:,3,3,4,2) =tens5174;
tens5(:,:,3,3,4,3) =tens5175;
tens5(:,:,3,3,4,4) =tens5176;
tens5(:,:,3,4,1,1) =tens5177;
tens5(:,:,3,4,1,2) =tens5178;
tens5(:,:,3,4,1,3) =tens5179;
tens5(:,:,3,4,1,4) =tens5180;
tens5(:,:,3,4,2,1) =tens5181;
tens5(:,:,3,4,2,2) =tens5182;
tens5(:,:,3,4,2,3) =tens5183;
tens5(:,:,3,4,2,4) =tens5184;
tens5(:,:,3,4,3,1) =tens5185;
tens5(:,:,3,4,3,2) =tens5186;
tens5(:,:,3,4,3,3) =tens5187;
tens5(:,:,3,4,3,4) =tens5188;
tens5(:,:,3,4,4,1) =tens5189;
tens5(:,:,3,4,4,2) =tens5190;
tens5(:,:,3,4,4,3) =tens5191;
tens5(:,:,3,4,4,4) =tens5192;
tens5(:,:,4,1,1,1) =tens5193;
tens5(:,:,4,1,1,2) =tens5194;
tens5(:,:,4,1,1,3) =tens5195;
tens5(:,:,4,1,1,4) =tens5196;
tens5(:,:,4,1,2,1) =tens5197;
tens5(:,:,4,1,2,2) =tens5198;
tens5(:,:,4,1,2,3) =tens5199;
tens5(:,:,4,1,2,4) =tens5200;
tens5(:,:,4,1,3,1) =tens5201;
tens5(:,:,4,1,3,2) =tens5202;
tens5(:,:,4,1,3,3) =tens5203;
tens5(:,:,4,1,3,4) =tens5204;
tens5(:,:,4,1,4,1) =tens5205;
tens5(:,:,4,1,4,2) =tens5206;
tens5(:,:,4,1,4,3) =tens5207;
tens5(:,:,4,1,4,4) =tens5208;
tens5(:,:,4,2,1,1) =tens5209;
tens5(:,:,4,2,1,2) =tens5210;
tens5(:,:,4,2,1,3) =tens5211;
tens5(:,:,4,2,1,4) =tens5212;
tens5(:,:,4,2,2,1) =tens5213;
tens5(:,:,4,2,2,2) =tens5214;
tens5(:,:,4,2,2,3) =tens5215;
tens5(:,:,4,2,2,4) =tens5216;
tens5(:,:,4,2,3,1) =tens5217;
tens5(:,:,4,2,3,2) =tens5218;
tens5(:,:,4,2,3,3) =tens5219;
tens5(:,:,4,2,3,4) =tens5220;
tens5(:,:,4,2,4,1) =tens5221;
tens5(:,:,4,2,4,2) =tens5222;
tens5(:,:,4,2,4,3) =tens5223;
tens5(:,:,4,2,4,4) =tens5224;
tens5(:,:,4,3,1,1) =tens5225;
tens5(:,:,4,3,1,2) =tens5226;
tens5(:,:,4,3,1,3) =tens5227;
tens5(:,:,4,3,1,4) =tens5228;
tens5(:,:,4,3,2,1) =tens5229;
tens5(:,:,4,3,2,2) =tens5230;
tens5(:,:,4,3,2,3) =tens5231;
tens5(:,:,4,3,2,4) =tens5232;
tens5(:,:,4,3,3,1) =tens5233;
tens5(:,:,4,3,3,2) =tens5234;
tens5(:,:,4,3,3,3) =tens5235;
tens5(:,:,4,3,3,4) =tens5236;
tens5(:,:,4,3,4,1) =tens5237;
tens5(:,:,4,3,4,2) =tens5238;
tens5(:,:,4,3,4,3) =tens5239;
tens5(:,:,4,3,4,4) =tens5240;
tens5(:,:,4,4,1,1) =tens5241;
tens5(:,:,4,4,1,2) =tens5242;
tens5(:,:,4,4,1,3) =tens5243;
tens5(:,:,4,4,1,4) =tens5244;
tens5(:,:,4,4,2,1) =tens5245;
tens5(:,:,4,4,2,2) =tens5246;
tens5(:,:,4,4,2,3) =tens5247;
tens5(:,:,4,4,2,4) =tens5248;
tens5(:,:,4,4,3,1) =tens5249;
tens5(:,:,4,4,3,2) =tens5250;
tens5(:,:,4,4,3,3) =tens5251;
tens5(:,:,4,4,3,4) =tens5252;
tens5(:,:,4,4,4,1) =tens5253;
tens5(:,:,4,4,4,2) =tens5254;
tens5(:,:,4,4,4,3) =tens5255;
tens5(:,:,4,4,4,4) =tens5256;
