function out = MLfast(t,coordinates,flag,y,z)
out{1} = @init;
out{2} = @fun_eval;
out{3} = @jacobian;
out{4} = @jacobianp;
out{5} = @hessians;
out{6} = @hessiansp;
out{7} = @der3;
out{8} = [];
out{9} = [];

% --------------------------------------------------------------------------
function dydt = fun_eval(t,kmrgd,y,z)
minf=(1+tanh((kmrgd(1)+0.01)/0.15))/2;
winf=(1+tanh((kmrgd(1)-z)/0.145))/2;
tau=cosh((kmrgd(1)-0.1)/0.29);
dydt=[y-0.5*(kmrgd(1)+0.5)-2*kmrgd(2)*(kmrgd(1)+0.7)-minf*(kmrgd(1)-1);
1.15*(winf-kmrgd(2))*tau;];

% --------------------------------------------------------------------------
function [tspan,y0,options] = init
handles = feval(MLfast);
y0=[0,0];
options = odeset('Jacobian',handles(3),'JacobianP',handles(4),'Hessians',handles(5),'HessiansP',handles(6));
tspan = [0 10];

% --------------------------------------------------------------------------
function jac = jacobian(t,kmrgd,y,z)
jac=[[-1-2*kmrgd(2)-(10/3-10/3*tanh(20/3*kmrgd(1)+1/15)^2)*(kmrgd(1)-1)-1/2*tanh(20/3*kmrgd(1)+1/15),-2*kmrgd(1)-7/5];[(115/29-115/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)+100/29*(23/40-23/40*tanh(-200/29*kmrgd(1)+200/29*z)-23/20*kmrgd(2))*sinh(100/29*kmrgd(1)-10/29),-23/20*cosh(100/29*kmrgd(1)-10/29)]];
% --------------------------------------------------------------------------
function jacp = jacobianp(t,kmrgd,y,z)
jacp=[[1,0];[0,(-115/29+115/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)]];
% --------------------------------------------------------------------------
function hess = hessians(t,kmrgd,y,z)
hess1=[[20/3*tanh(20/3*kmrgd(1)+1/15)*(20/3-20/3*tanh(20/3*kmrgd(1)+1/15)^2)*(kmrgd(1)-1)-20/3+20/3*tanh(20/3*kmrgd(1)+1/15)^2,-2];[-230/29*tanh(-200/29*kmrgd(1)+200/29*z)*(-200/29+200/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)+200/29*(115/29-115/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*sinh(100/29*kmrgd(1)-10/29)+10000/841*(23/40-23/40*tanh(-200/29*kmrgd(1)+200/29*z)-23/20*kmrgd(2))*cosh(100/29*kmrgd(1)-10/29),-115/29*sinh(100/29*kmrgd(1)-10/29)]];
hess2=[[-2,0];[-115/29*sinh(100/29*kmrgd(1)-10/29),0]];
hess(:,:,1) =hess1;
hess(:,:,2) =hess2;
% --------------------------------------------------------------------------
function hessp = hessiansp(t,kmrgd,y,z)
hessp1=[[0,0];[0,0]];
hessp2=[[0,0];[-230/29*tanh(-200/29*kmrgd(1)+200/29*z)*(200/29-200/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)+100/29*(-115/29+115/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*sinh(100/29*kmrgd(1)-10/29),0]];
hessp(:,:,1) =hessp1;
hessp(:,:,2) =hessp2;
%---------------------------------------------------------------------------
function tens3  = der3(t,kmrgd,y,z)
tens31=[[20/3*(20/3-20/3*tanh(20/3*kmrgd(1)+1/15)^2)^2*(kmrgd(1)-1)-800/9*tanh(20/3*kmrgd(1)+1/15)^2*(20/3-20/3*tanh(20/3*kmrgd(1)+1/15)^2)*(kmrgd(1)-1)+20*tanh(20/3*kmrgd(1)+1/15)*(20/3-20/3*tanh(20/3*kmrgd(1)+1/15)^2),0];[-230/29*(-200/29+200/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)^2*cosh(100/29*kmrgd(1)-10/29)-92000/841*tanh(-200/29*kmrgd(1)+200/29*z)^2*(-200/29+200/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)-69000/841*tanh(-200/29*kmrgd(1)+200/29*z)*(-200/29+200/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*sinh(100/29*kmrgd(1)-10/29)+30000/841*(115/29-115/29*tanh(-200/29*kmrgd(1)+200/29*z)^2)*cosh(100/29*kmrgd(1)-10/29)+1000000/24389*(23/40-23/40*tanh(-200/29*kmrgd(1)+200/29*z)-23/20*kmrgd(2))*sinh(100/29*kmrgd(1)-10/29),-11500/841*cosh(100/29*kmrgd(1)-10/29)]];
tens32=[[0,0];[-11500/841*cosh(100/29*kmrgd(1)-10/29),0]];
tens33=[[0,0];[-11500/841*cosh(100/29*kmrgd(1)-10/29),0]];
tens34=[[0,0];[0,0]];
tens3(:,:,1,1) =tens31;
tens3(:,:,1,2) =tens32;
tens3(:,:,2,1) =tens33;
tens3(:,:,2,2) =tens34;
%---------------------------------------------------------------------------
function tens4  = der4(t,kmrgd,y,z)
%---------------------------------------------------------------------------
function tens5  = der5(t,kmrgd,y,z)
