function [x0,v0] = init_ZH_NS(odefile, x, p, s, ap, ntst, ncol, eps)
%
% [x0,v0] = init_ZH_NS(odefile, x, p, s, ap, ntst, ncol,eps)
%

global lds cds
% check input
if(size(ap)~= 2)
  error('Two active parameters are needed for a torus bifurcation curve continuation');
end

cds.curve = @equilibrium;
curvehandles = feval(cds.curve);
cds.curve_func = curvehandles{1};
cds.curve_jacobian = curvehandles{4};
cds.curve_hessians = curvehandles{5};
x0 = x(:,s.index);

% initialize lds
init_lds(odefile,x,p,s,ap,ntst,ncol);
func_handles = feval(odefile);
symord = 0; 
symordp = 0;
if     ~isempty(func_handles{9}),   symord = 5; 
elseif ~isempty(func_handles{8}),   symord = 4; 
elseif ~isempty(func_handles{7}),   symord = 3; 
elseif ~isempty(func_handles{5}),   symord = 2; 
elseif ~isempty(func_handles{3}),   symord = 1; 
end

if     ~isempty(func_handles{6}),   symordp = 2; 
elseif ~isempty(func_handles{4}),   symordp = 1; 
end

cds.options = contset(cds.options, 'SymDerivative', symord);
cds.options = contset(cds.options, 'SymDerivativeP', symordp);
cds.symjac = 1;
cds.symhess = 0;

lds.odefile = odefile;
lds.func = func_handles{2};
lds.Jacobian  = func_handles{3};
lds.JacobianP = func_handles{4};
lds.Hessians  = func_handles{5};
lds.HessiansP = func_handles{6};
lds.Der3 = func_handles{7};
lds.Der4 = func_handles{8};
lds.Der5 = func_handles{9};

x = x0(1:lds.nphase);
p(ap) = x0(lds.nphase+1:lds.nphase+2);

eds.ActiveParams = ap;
eds.P0 = p;
lds.P0 = p;

cds.oldJac = [];
cds.oldJacX = [];

%Checking Nondegeneracy and the theoretical possibility to switch.
  pp=p; p = num2cell(p);
  nphase=lds.nphase;
  jac = cjac(lds.func,lds.Jacobian,x,p,lds.ActiveParams);
  [X,D] = eig(jac);
  index1 = find( abs(diag(D))<1e-6 & sign(imag(diag(D)))==0);% fold part.
  index2 = find(abs(real(diag(D)))<1e-6 & sign(imag(diag(D)))==1);% hopf part.
if(isempty(index2)==1)
  debug('Neutral saddle\n');
  x0=[];
  v0=[];
  return;
end
% ev0 = diag(D(index1,index1));
  ev1 = diag(D(index2,index2));
  q0 = X(:,index1);
  q1 = X(:,index2);
  [X,D] = eig(jac');
  index1 = find( abs(diag(D))<1e-6 & sign(imag(diag(D)))== 0);% fold part.
  index2 = find(abs(real(diag(D))) <1e-6 & sign(imag(diag(D)))==-1);% hopf part.
  qad0 = X(:,index1);
  qad1 = X(:,index2);
  p0 = qad0/(q0'*qad0);
  p1 = qad1/(q1'*qad1);  
  hessIncrement = (cds.options.Increment)^(3.0/4.0);
  ten3Increment = (cds.options.Increment)^(3.0/5.0);
  if (cds.options.SymDerivative >= 2)
    hess = chess(odefile,lds.Jacobian,lds.Hessians,x,p,lds.ActiveParams);
  else
    hess = [];
  end
  if (cds.options.SymDerivative >= 3)
    tens = ctens3(odefile,lds.Jacobian,lds.Hessians,lds.Der3,x,p,lds.ActiveParams);
  else
    tens = [];
  end
  h110 = multilinear2(lds.func,hess,q0,q1,x,p,hessIncrement);		% B(q0,q1)
  h011 = multilinear2(lds.func,hess,q1,conj(q1),x,p,hessIncrement);	% B(q1,conj(q1))
  f011 = p0'*h011; g110 = p1'*h110;
if(real(g110)*f011 > 0 )
  debug('Switching theoretically not possible\n');
  x0 = [];
  v0 = [];
  return;
end    
  h200 = multilinear2(lds.func,hess,q0,q0,x,p,hessIncrement);		% B(q0,q0)
  h020 = multilinear2(lds.func,hess,q1,q1,x,p,hessIncrement);		% B(q1,q1)
  f200 = p0'*h200/2.0;
  Bordfold = [jac q0 ; p0' 0];
  h200 = Bordfold \ [2*f200*q0-h200 ; 0]; h200 = h200(1:nphase);	%-A^{INV}( B(q0,q0) - <p0,B(q0,q0)>q0 ) 
  h110 = [(ev1*eye(nphase)-jac) q1 ; p1' 0] \ [h110-g110*q1 ; 0];
  h110 = h110(1:nphase);
  h020 = (2*ev1*eye(nphase) -jac)\h020;
  h011 = Bordfold \ [f011*q0 - h011 ; 0];  h011 = h011(1:nphase);
  h111 = multilinear3(lds.func,tens,q0,q1,conj(q1),x,p,ten3Increment);		%  C(q0,q1,conj(q1))
  h111 = h111 +2*real(multilinear2(lds.func,hess,q1,conj(h110),x,p,hessIncrement));%+2Re(B(q1,h101))
  h111 = h111 + multilinear2(lds.func,hess,q0,h011,x,p,hessIncrement);  	%+2B(q0,h011)
  h021 = multilinear3(lds.func,tens,q1,q1,conj(q1),x,p,ten3Increment);		%  C(q1,q1,conj(q1))
  h021 = h021 + 2*multilinear2(lds.func,hess,q1,h011,x,p,hessIncrement);	%+2B(q1,h011)
  h021 = h021 +   multilinear2(lds.func,hess,conj(q1),h020,x,p,hessIncrement);	%+ B(conj(q1),h020)
  f111 = p0'*h111; g021 = p1'*h021/2.0;
%Checking Transversality
  J1 = cjacp(lds.func,lds.JacobianP,x,p,ap);
  gg = (p0'*J1)';
  s1 = gg/(gg'*gg); s2 = [gg(2) ; -gg(1)];
  hh00010 = Bordfold \ [q0-J1*s1 ;0]; hh00010 = hh00010(1:nphase);
  hh00001 = Bordfold \ [  -J1*s2 ;0]; hh00001 = hh00001(1:nphase);
  hessp=chessp(lds.func,lds.Jacobian,lds.HessiansP,x,p,ap);
  test11 = zeros(nphase,1); for i=1:2 ; test11 = test11 + hessp(:,:,i)*s1(i)*q0 ; end
  test12 = zeros(nphase,1); for i=1:2 ; test12 = test12 + hessp(:,:,i)*s1(i)*q1 ; end
  test21 = zeros(nphase,1); for i=1:2 ; test21 = test21 + hessp(:,:,i)*s2(i)*q0 ; end
  test22 = zeros(nphase,1); for i=1:2 ; test22 = test22 + hessp(:,:,i)*s2(i)*q1 ; end
  LL = [ p0'*(test21 + multilinear2(lds.func,hess,q0,hh00001,x,p,hessIncrement)) 2*f200;
      p1'*(test22 + multilinear2(lds.func,hess,q1,hh00001,x,p,hessIncrement)) g110];
  RR = [ -p0'*(test11 + multilinear2(lds.func,hess,q0,hh00010,x,p,hessIncrement));
     -p1'*(test12 + multilinear2(lds.func,hess,q1,hh00010,x,p,hessIncrement))];
  dd1 = real(LL\RR); dd2 = real(LL)\[ 0; 1];
  v10 = s1 + dd1(1)*s2; h00010 = hh00010 + dd1(1)*hh00001 + dd1(2)*q0;  
  v01 = dd2(1)*s2; h00001 = dd2(1)*hh00001 + dd2(2)*q0;  
  beta2dir =((2*(real(g110)-f200)*real(g021)+real(g110)*f111)/2/f200);
  xdir = -(f111+2*real(g021))/2/f200;
  imagp1 = imag(LL(2,:)*dd1-RR(2));
  imagp2 = imag(LL(2,:)*dd2);
  x0 = zeros(ntst*nphase+2,1);v0 = zeros(ntst*nphase+2,1);
  newbase = x+(-f011*h00010+beta2dir*h00001+xdir*q0 + h011)*eps^2;
for i=1:lds.ncoords/lds.nphase
    zphase = exp(sqrt(-1.0)*2*pi*i/((lds.ncoords/lds.nphase) -1));
    x0(((i-1)*nphase+1):((i-1)*nphase+nphase)) = newbase + real(2*q1*zphase*eps + h020*zphase^2*eps^2);
    v0(((i-1)*nphase+1):((i-1)*nphase+nphase)) = 2*(newbase-x)/eps+real(2*q1*zphase + 2*h020*zphase^2*eps);
end
% generate a new mesh and interpolate
resc=norm(v0);
[x0,v0]=new_mesh(x0,v0,ntst,ncol);

% append period, parameters and k
omega1 = sqrt(2*abs(real(g110) * f011))*eps;
omega2 = imag(ev1);
k = 1-(2*pi*omega1/omega2)^2/2;
x0(lds.ncoords+1)= (2*pi/omega2);
x0(lds.ncoords+(2:3)) = pp(ap)+(-f011*v10+beta2dir*v01)*eps^2;
x0(lds.ncoords+4) = k;
x0 = real(x0);

% approximate tangent vector
v0(lds.ncoords+1)=-4*pi*(-f011*imagp1+beta2dir*imagp2+imag(g110)*xdir+imag(g021))*eps/(omega2^2);
v0(lds.ncoords+(2:3))= 2*(-f011*v10+beta2dir*v01)*eps;
v0(lds.ncoords+4)= 8*pi^2*real(g110)*f011*eps/omega2^2;
v0(lds.ncoords+(1:4))=v0(lds.ncoords+(1:4))/resc;
v0=real(v0)/norm(v0);

[x1,p2,T]=rearr(x0);p1 = num2cell(p2);
jac = spalloc(2*lds.ncoords-lds.nphase,2*lds.ncoords-lds.nphase,(2*lds.tps-1)*lds.nphase*3+(2*lds.ncol+1)*lds.nphase*2*lds.ntst);
ups = reshape(x1,lds.nphase,lds.tps);
% function
range1 = lds.col_coords;
range2 = lds.cols_p1_coords;
for ns = 1:2
    range0 = lds.cols_p1;
    for j = lds.tsts
        xp = ups(:,range0)*lds.wt;
        jac(range1,range2) = bordBVP_NS_f(lds.func,xp,p1,T,j);
        range0 = range0 + lds.ncol;
        range1 = range1 + lds.ncol_coord;
        range2 = range2 + lds.ncol_coord;
    end
end

% boundary conditions
range  = 2*(lds.tps-1)*lds.nphase+ (lds.phases);
range2  = 2*(lds.ncoords-lds.nphase)+lds.phases;
range1 = lds.ncoords-lds.nphase+lds.phases;
jac(range,[lds.phases range1 range2]) = bordBVP_NS_bc1(k);

%compute borders
dimdoub=2*lds.ncoords-lds.nphase;
jace=[jac rand(dimdoub,2);rand(2,dimdoub) zeros(2,2)];
b=zeros(dimdoub+2,2);b(dimdoub+1,1)=1;b(dimdoub+2,2)=1;
q=jace\b;q=q(1:dimdoub,:);q=orth(q);
lds.NS_phi0 = q(:,1); 
lds.NS_phi1 = q(:,2);
p=jace'\b;p=p(1:dimdoub,:);p=orth(p);
lds.NS_psi0 = p(:,1); 
lds.NS_psi1 = p(:,2);

for i=1:lds.tps
    lds.upoldp(:,i) = T*feval(lds.func, 0, ups(:,i), p1{:});
end

%compute indices
A = NS_BVP_jac('BVP_LC_jac_f','BVP_LC_jac_bc','BVP_LC_jac_ic',x1,p2,T,3,2);
[Q,R] = qr(A');
Bord  = [jac lds.NS_psi0 lds.NS_psi1; [lds.NS_phi0';lds.NS_phi1'] zeros(2)];
bunit = zeros((2*lds.tps-1)*lds.nphase+2,2);
bunit(end-1:end,:) = eye(2);
sn = Bord\bunit;
st = Bord'\bunit;
v = sn(1:end-2,:)';
w = st(1:end-2,:)';
w1 = w(:,end-lds.nphase+1:end);

% calculate g'
ups = reshape(x1,lds.nphase,lds.tps);
p = num2cell(p1);

range1 = lds.col_coords;
range2 = lds.cols_p1_coords;
cv=[];
t = lds.nphase:((lds.ncol+2)*lds.nphase-1);
kr1 = fix(t/lds.nphase);
kr2 = rem(t,lds.nphase)+1;
gx = zeros(4,lds.ncoords+3);gk=[];
for ns = 1:2
      range3 = lds.cols_p1_coords;
      v1     = cv  ;
      range0 = lds.cols_p1;
      for tstpt = lds.tsts
          xp  = ups(:,range0)*lds.wt;
          cv = v(:,range2)';
          cw = w(:,range1);
          range = lds.phases;
          for c = lds.cols
              xt    = xp(:,c);
              sysj  = cjac(lds.func,lds.Jacobian,xt,p1,lds.ActiveParams);
              sysh  = chess(lds.func,lds.Jacobian,lds.Hessians,xt,p1,lds.ActiveParams);
              syshp = chessp(lds.func,lds.Jacobian,lds.HessiansP,xt,p1,lds.ActiveParams);
              wtk   = lds.wt(kr1,c(ones(1,lds.nphase)))';
              for d = lds.phases
                  sh1(:,d) = (wtk.*sysh(:,kr2,d))*cv(:,1);
                  sh2(:,d) = (wtk.*sysh(:,kr2,d))*cv(:,2);
              end      
              t11 = T* wtk.*sh1(:,kr2);
              t21 = T* wtk.*sh2(:,kr2);
              t12 = (wtk.*sysj(:,kr2))*cv(:,1);
              t22 = (wtk.*sysj(:,kr2))*cv(:,2);
              t13 = T* wtk.*syshp(:,kr2,1)* cv(:,1);
              t23 = T* wtk.*syshp(:,kr2,1)* cv(:,2);
              t14 = T* wtk.*syshp(:,kr2,2)* cv(:,1);
              t24 = T* wtk.*syshp(:,kr2,2)* cv(:,2);
              syshess1(range,:) = [t11 t12 t13 t14];      
              syshess2(range,:) = [t21 t22 t23 t24];      
              range = range + lds.nphase;    
          end
          gx(1,[range3 lds.ncoords+(1:3)]) = gx(1,[range3 lds.ncoords+(1:3)]) + cw(1,:)*syshess1;
          gx(2,[range3 lds.ncoords+(1:3)]) = gx(2,[range3 lds.ncoords+(1:3)]) + cw(1,:)*syshess2;
          gx(3,[range3 lds.ncoords+(1:3)]) = gx(3,[range3 lds.ncoords+(1:3)]) + cw(2,:)*syshess1;
          gx(4,[range3 lds.ncoords+(1:3)]) = gx(4,[range3 lds.ncoords+(1:3)]) + cw(2,:)*syshess2;
          range0 = range0 + lds.ncol;
          range1 = range1 + lds.ncol_coord;
          range2 = range2 + lds.ncol_coord;
          range3 = range3 + lds.ncol_coord;
      end
end  

gk(1,1) = 2*w1(1,:)*v1(end-lds.nphase+1:end,1);
gk(2,1) = 2*w1(1,:)*v1(end-lds.nphase+1:end,2);
gk(3,1) = 2*w1(2,:)*v1(end-lds.nphase+1:end,1);
gk(4,1) = 2*w1(2,:)*v1(end-lds.nphase+1:end,2);

B = [A ; gx gk]*Q;
Jres = B(2+lds.ncoords:end,2+lds.ncoords:end)';
[Q,R,E] = qr(full(Jres));
index = [1 1;1 2;2 1;2 2];
[I,J] = find(E(:,1:2));
lds.index1 = index(I(J(1)),:);
lds.index2 = index(I(J(2)),:);

%----------------------------------------------------------------------
function [x,p,T] = rearr(x0)
%
% [x,p] = rearr(x0)
%
% Rearranges x0 into coordinates (x) and parameters (p)

global lds
nap = length(lds.ActiveParams);
lds.PeriodIdx = lds.ncoords+1;

p = lds.P0;
p(lds.ActiveParams) = x0(lds.PeriodIdx+(1:nap));

x = x0(lds.coords);
T = x0(lds.ncoords+1);
lds.T =T;

%-----------------------------------------------------------------
function init_lds(odefile,x,p,s,ap,ntst,ncol)
global lds
lds=[];
lds.odefile = odefile;
func_handles = feval(lds.odefile);
lds.func = func_handles{2};
lds.Jacobian  = func_handles{3};
lds.JacobianP = func_handles{4};
lds.Hessians  = func_handles{5};
lds.HessiansP = func_handles{6};
lds.Der3=func_handles{7};
lds.Der4=func_handles{8};
lds.Der5=func_handles{9};
siz = size(func_handles,2);
if siz > 9
    j=1;
    for k=10:siz
        lds.user{j}= func_handles{k};
        j=j+1;
    end
    else lds.user=[];              
end
lds.nphase = size(s.data.evec,2);
lds.ActiveParams = ap;
lds.P0 = p;
set_ntst_ncol(ntst,ncol,(0:ntst)/ntst);

lds.T = [];
lds.cols_p1 = 1:(lds.ncol+1);
lds.cols_p1_coords = 1:(lds.ncol+1)*lds.nphase;
lds.ncol_coord = lds.ncol*lds.nphase;
lds.col_coords = 1:lds.ncol*lds.nphase;
lds.pars = lds.ncoords+(1:4);
lds.phases = 1:lds.nphase;
lds.ntstcol = lds.ntst*lds.ncol;
lds.wp = kron(lds.wpvec',eye(lds.nphase));
lds.pwwt = kron(lds.wt',eye(lds.nphase));
lds.pwi = lds.wi(ones(1,lds.nphase),:);

lds.PD_psi = [];
lds.PD_phi = [];
lds.PD_new_phi = [];
lds.PD_new_psi = [];
lds.PD_switch = 0;

lds.BP_psi = [];
lds.BP_phi = [];
lds.BP_psi1 = [];
lds.BP_phi1 = [];
lds.BP_new_phi = [];
lds.BP_new_psi = [];
lds.BP_new_psi1 = [];
lds.BP_new_phi1 = [];
lds.BP_switch = 0;

lds.BPC_switch = 0;
lds.BPC_psi = [];
lds.BPC_phi1 = [];
lds.BPC_phi2 = [];

lds.LPC_phi = [];
lds.LPC_psi = [];
lds.LPC_new_phi = [];
lds.LPC_new_psi = [];
lds.LPC_switch = 0;

lds.NS_psi0 = [];
lds.NS_psi1 = [];
lds.NS_phi0 = [];
lds.NS_phi1 = [];

lds.NS1_new_phi = [];
lds.NS2_new_phi = [];
lds.NS1_new_psi = [];
lds.NS2_new_psi = [];
lds.NS_new_phi = [];
lds.NS_new_psi = [];
lds.NS_switch = 0;
lds.NS1_switch = 0;
lds.NS2_switch = 0;

lds.bialt_M1 = [];
lds.bialt_M2 = [];
lds.bialt_M3 = [];
lds.bialt_M4 = [];
lds.multipliers = nan;
lds.monodromy = [];
lds.multi_r1 = [];
lds.multi_r2 = [];
lds.BranchParam = lds.ActiveParams;
lds.ups = [];
lds.vps = [];
lds.BranchParams=[];
lds.tsts = 1:lds.ntst;
lds.cols = 1:lds.ncol;

