function vec3 = multilinear3(odefile,tens3,q1,q2,q3,x0,p,increment)
%--------------------------------------------------------------
% This file computes the multilinear function C(q1,q2,q3) where
% C = D^3(F(x0)), the 3rd derivative of the vectorfield w.r.t. to phase
% variables only. 
% Directional derivatives are done on unit vectors q1,q2 for accuracy. 
% In case of imaginary vectors, make a call to this function but now with
% real vectors. Necessary as the model may be invalid for complex arguments
%--------------------------------------------------------------

nphase=size(x0,1);
[nq1,q1]=vecscale(q1);
[nq2,q2]=vecscale(q2);
[nq3,q3]=vecscale(q3);

if (~isempty(tens3)) % Symbolic
  vec3=tensor3op(tens3,q1,q2,q3,nphase);
elseif (isreal(q1) && isreal(q2) && isreal(q3)) % Check for real vectors
  if(isequal(q1,q2))
    if(isequal(q1,q3))
      vec3 = Cvvv(odefile,q1,x0,p,increment);
    else
      part1 = Cvvv(odefile,q1+q3,x0,p,increment);
      part2 = Cvvv(odefile,q1-q3,x0,p,increment);
      part3 = Cvvv(odefile,q3,x0,p,increment);
      vec3 = (part1 - part2 - 2.0*part3)/6.0;
    end
  else
    part1 = Cvvv(odefile,q1+q2+q3,x0,p,increment);
    part2 = Cvvv(odefile,q1+q2-q3,x0,p,increment);
    part3 = Cvvv(odefile,q1-q2+q3,x0,p,increment);
    part4 = Cvvv(odefile,q1-q2-q3,x0,p,increment);
    vec3 = (part1 - part2 - part3 + part4)/24.0;
  end
else %Case of complex vectors q1,q2,q3, call to self with real ones.
  q1r=real(q1);q1i=imag(q1);
  q2r=real(q2);q2i=imag(q2);
  q3r=real(q3);q3i=imag(q3);
  part1 = multilinear3(odefile,[],q1r,q2r,q3r,x0,p,increment);
  part2 = multilinear3(odefile,[],q1r,q2r,q3i,x0,p,increment);
  part3 = multilinear3(odefile,[],q1r,q2i,q3r,x0,p,increment);
  part4 = multilinear3(odefile,[],q1i,q2r,q3r,x0,p,increment);
  part5 = multilinear3(odefile,[],q1r,q2i,q3i,x0,p,increment);
  part6 = multilinear3(odefile,[],q1i,q2r,q3i,x0,p,increment);
  part7 = multilinear3(odefile,[],q1i,q2i,q3r,x0,p,increment);
  part8 = multilinear3(odefile,[],q1i,q2i,q3i,x0,p,increment);
  vec3 = part1-part5-part6-part7+1i*(part2+part3+part4-part8);
end
vec3=nq1*nq2*nq3*vec3;

%----------------------------------------------------
function tempvec = Cvvv(odefile,vq,x0,p,increment)

  f1 = x0 + 3.0*increment*vq;
  f2 = x0 +     increment*vq;
  f3 = x0 -     increment*vq;
  f4 = x0 - 3.0*increment*vq;

  f1 = feval(odefile, 0, f1, p{:});
  f2 = feval(odefile, 0, f2, p{:});
  f3 = feval(odefile, 0, f3, p{:});
  f4 = feval(odefile, 0, f4, p{:});

  tempvec = (f1 - 3.0*f2 + 3.0*f3 - f4)/((2*increment)^3);

%----------------------------------------------------
function [nq,q_scaled]=vecscale(q)
  if (norm(q)>1)
    nq=norm(q);
    q_scaled=q/nq;
  else
    nq=1;
    q_scaled=q;
  end