function vec2 = multilinear2(odefile,tens2,q1,q2,x0,p,increment)

%----------------------------------------------------------

% This file computes the multilinear function B(q1,q2) where
% B = D^2(F(x0)), the second derivative of the vectorfield 
% Directional derivatives are done on unit vectors q1,q2 for accuracy. 
% In case of imaginary vectors, make a call to this function but now with
% real vectors. Necessary as the model may be invalid for complex arguments

%----------------------------------------------------

nphase=size(x0,1);
[nq1,q1]=vecscale(q1);
[nq2,q2]=vecscale(q2);

if (~isempty(tens2)) %Symbolic
  vec2=tensor2op(tens2,q1,q2,nphase);
elseif(isreal(q1) && isreal(q2))% Check for real Vectors
  if(isequal(q1,q2))
    vec2 = Bvv(odefile,q1,x0,p,increment);
  else
    part1 = Bvv(odefile,q1+q2,x0,p,increment);
    part2 = Bvv(odefile,q1-q2,x0,p,increment);
    vec2 = (part1-part2)/4.0;
  end
else % Complex vectors, call to self      
  q1r=real(q1);q1i=imag(q1);
  q2r=real(q2);q2i=imag(q2);
  part1 = multilinear2(odefile,[],q1r,q2r,x0,p,increment);
  part2 = multilinear2(odefile,[],q1r,q2i,x0,p,increment);
  part3 = multilinear2(odefile,[],q1i,q2r,x0,p,increment);
  part4 = multilinear2(odefile,[],q1i,q2i,x0,p,increment);
  vec2 = part1+1i*(part2+part3)-part4;
end
vec2=nq1*nq2*vec2;

%----------------------------------------------------
function tempvec = Bvv(odefile,vq,x0,p,increment)

  f0 = x0;
  f1 = x0 + increment*(vq);
  f2 = x0 - increment*(vq);
  
  f0 = feval(odefile, 0, f0, p{:});
  f1 = feval(odefile, 0, f1, p{:});
  f2 = feval(odefile, 0, f2, p{:});

  tempvec = (f1+f2-2.0*f0)/increment^2;

%----------------------------------------------------
function [nq,q_scaled]=vecscale(q)
  if (norm(q)>1)
    nq=norm(q);
    q_scaled=q/nq;
  else
    nq=1;
    q_scaled=q;
  end
