classdef DefaultValues
    
    properties(Constant)
        BACKGROUNDCOLOR = [0.98 0.98 0.98];
        SECTIONNAMESETTING = {'horizontalalignment','center', 'FontAngle', 'italic','BackgroundColor' , [0.98 0.98 0.98]};
        LETTERDIMENSION = DefaultValues.getLetterDimension();
        
        CONTINUERDATA = struct(    ...
            'InitStepSize' , 0.01,    ...
            'MinStepSize' , 1e-5,    ...
            'MaxStepSize' , 0.1,    ...
            'MaxNewtonIters' , 3,    ...
            'MaxCorrIters' , 10,    ...
            'TestIters' , 10,    ...
            'VarTolerance' , 1e-06,    ...
            'FunTolerance' , 1e-06,    ...
            'TestTolerance' , 1e-05,    ...
            'Adapt' , 3,    ...
            'MaxNumPoints' , 300,    ...
            'ClosedCurve' , 50 );
        
        OPTIONS = struct( ...
            ... %Suspend Computation
            'suspend' , 1 , ...%  1 = at special points, 2 = each point , 3 = never.
            ... % Maximum number of untitled curves of a particular type'
            'archive' , 2 , ...
            ... % Plot after X points
            'plotoutput' , 1);

        STARTERDATA = struct( ...
            'eps1tol', 0.01,...
            'ntst', 40, ...
            'ncol', 4);
        
        
         TESTFUNCTIONS = struct( ...
                'P',	'Point',...
                'O',	'Orbit',...
                'EP',	'Equilibrium',...
                'LC',	'Limit cycle',...
                'LP',	'Limit Point (fold) bifurcation',...
                'H',	'Hopf bifurcation',...
                'LPC',	'Limit Point bifurcation of cycles',...
                'NS',	'Neimark-Sacker (torus) bifurcation',...
                'PD',	'Period Doubling (flip) bifurcation',...
                ... %'BP',	'Branch Point',...
                'CP',	'Cusp bifurcation',...
                'BT',	'Bogdanov-Takens bifurcation',...
                'ZH',	'Zero-Hopf bifurcation',...
                'HH',	'Double Hopf bifurcation',...
                'GH',	'Generalized Hopf (Bautin) bifurcation',...
                'BPC',	'Branch Point of Cycles',...
                'CPC',	'Cusp bifurcation of Cycles',...
                'R1',	'1:1 Resonance',...
                'R2',	'1:2 Resonance',...
                'R3',	'1:3 Resonance',...
                'R4',	'1:4 Resonance',...
                'CH',	'Chenciner (generalized NS) bifurcation',...
                'LPNS',	'Fold-Neimark-Sacker bifurcation',...
                'PDNS',	'Flip-Neimark-Sacker bifurcation',...
                'LPPD',	'Fold-flip',...
                'NSNS',	'Double Neimark-Sacker',...
                'GPD',	'Generalized Period Doubling',...
                'BP', 'Branching',...
                'HHS',	'Homoclinic to Hyperbolic Saddle',...
                'HSN',	'Homoclinic to Saddle-Node',...
                'NSS',	'Neutral saddle',...
                'NSF',	'Neutral saddle-focus',...
                'NFF',	'Neutral Bi-Focus',...
                'SH',	'Shilnikov-Hopf',...
                'DRS',	'Double Real Stable leading eigenvalue',...
                'DRU',	'Double Real Unstable leading eigenvalue',...
                'NDS',	'Neutrally-Divergent saddle-focus (Stable)',...
                'NDU',	'Neutrally-Divergent saddle-focus (Unstable)',...
                'test_3LS',	'Three Leading eigenvalues (Stable)',...
                'test_3LU',	'Three Leading eigenvalues (Unstable)',...
                'OFS',	'Orbit-Flip with respect to the Stable manifold',...
                'OFU',	'Orbit-Flip with respect to the Unstable manifold',...
                'IFS',	'Inclination-Flip with respect to the Stable manifold',...
                'IFU',	'Inclination-Flip with respect to the Unstable manifold',...
                'NCH',	'Non-Central Homoclinic to saddle-node');
        
            
          CURVENAMES = struct( ...
                'O',	'Orbit',...
                'EP',	'Equilibrium',...
                'LC',	'Limit cycle',...
                'LP',	'Limit point',...
                'H',	'Hopf',...
                'LPC',	'Limit point of cycles',...
                'NS',	'Neimark-Sacker',...
                'PD',	'Period-doubling',...
                'BP',	'Branch point',...
                'BPC',	'Branch point of cycles',...
                'DO',   'Discrete orbit',...
                'Hom', 'Homoclinic to saddle', ...
                'HSN', 'Homoclinic to saddle-node', ...
                'ConnecHom', 'ConnectionSaddle', ...
                'ConnecHSN', 'ConnectionSaddleNode', ...
                'HTHom', 'HomotopySaddle', ...
                'HTHSN', 'HomotopySaddleNode', ...
                'ConnecHet', 'ConnectionHet', ...
                'HTHet', 'HomtopyHet', ...
                'Het', 'Heteroclinic')
            

        SECTIONID = struct('CONTINUER', 1, 'STARTER', 2, 'INTEGRATOR', 3);
        SECTIONHEADER = struct('CONTINUER', 'Continuer', 'STARTER', 'Starter', 'INTEGRATOR', 'Integrator');    
        SECTIONNAMES = struct('s0_0', ' ', 's0_5', ' ', 's1_1', 'Continuation Data', 's1_2', 'Corrector Data', 's1_3', 'Stop Data', 's1_5', 'Advanced Options', 's2_1', 'Initial Point', 's2_2', '', 's2_3', '', 's2_4', 'Discretization Data','s2_5', 'Switch Data' , 's2_6', 'Monitor Singularities', 's2_7', 'Monitor userfunctions', 's3_1', '', 's2_9', 'Calculate multipliers', 's2_10', 'Calculate eigenvalues', 's2_100', 'Phase Response Curve', 's2_150', 'Homoclinic parameters', 's2_131', 'Target Point');
        PRIORITY = struct(...
            'P','O_DO', ...
            'EP','EP_ConnecHom_ConnecHet', ...
            'LC','LC_Hom_HSN', ...
            'PD','LC_PD', ...
            'LPC','LPC_LC', ...
            'NS','NS_LC', ...
            'H','LC_H', ...
            'LP','LP_ConnecHSN', ...
            'BP','EP_LP_BP', ...
            'CP','LP', ...
            'BT','LP_H_Hom', ...
            'GH','LC_H_LPC', ...
            'ZH','LC_H_LP_NS', ...
            'HH','NS_LC_H', ...
            'BPC','LC_LPC_BPC', ...
            'CPC','LPC', ...
            'GPD','PD_LPC', ...
            'Hom','Hom', ...
            'HSN','HSN', ...
            'NCH','Hom_HSN', ...
            'ConnecHom','HTHom', ...
            'ConnecHSN','HTHSN', ...
            'HTHom','HTHom_Hom', ...
            'HTHSN','HTHSN_HSN', ...
            'ConnecHet','HTHet', ...
            'HTHet','HTHet_Het', ...
            'Het','Het');
    end
    
    
    methods(Static)
        function dim = getLetterDimension()
            f = figure('Visible', 'off'); 
            x = uicontrol(f, 'style', 'edit', 'String', 'X');
            dim = x.Extent(end-1:end);
            delete([f,x]);
        end
        
        function o = getPriority(curvelabel)
            if isfield(DefaultValues.PRIORITY, curvelabel)
                o = strsplit(DefaultValues.PRIORITY.(curvelabel), '_');
            else
                o = {};
            end
            
            
        end
        
    end
    
    
    
    
end
