function MGtentminnotran(alpha,beta,gamma, tau, x0, T, n , w, l, p)
%Plots the tent map of minima of the x(t-w) coordinate lower than the
%bound l in the two-dimensional projection of the attractor given by the
%function MGattractor2D
%T is the time interval on which the solution is integrated
%n is the number of equal steps in the interval [0,tau]
% w is an arbitrary delay to compute a projection 
%Only points with x(t-tau) coordinate lower than l are considered
%p is the last percentage of the solution considered in order to avoid transient behavior
%if p=0.1 then only the last 10% of the solution is considered for the plot

ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step size in the interval [0,tau]
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=p*T/h;          %number of steps in the interval [T-p*T,T]
tspan = linspace(0,T,N);
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(T-p*T,T-w, N); 
solx = deval(sol,tspanx);        %solx is x(t-tau)
tspany= linspace(T+w-p*T,T, N);
soly = deval(sol,tspany);        %soly is x(t)
L=length(solx);
X=solx(2:L-1);
Y=solx(1:L-2);
Z=solx(3:L);

indcrit=find( X<Y & X<Z & X<l);     %indeces of the critical points 
crit= X(indcrit);                   %critical points
Mn_1= [];
Mn=[];
Mn_1= crit(1:end-1);
Mn=crit(2:end);

plot(Mn_1, Mn, 'b.');
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ', \ \tau = ' num2str(tau) ',\ w = ' num2str(w) ',\ l = ' num2str(l) ',\ T = ' num2str(T) ' , \ p = ' num2str(p) '$'];
title(titolo, 'Interpreter','latex')
 axis([0.2 0.9  0.2  0.9]);
xlabel('M_{n-1}');
ylabel('M_n');
grid on;
