function MGtentmin(alpha,beta,gamma, tau, x0, T, n , w, l)
%Plots the tent map of minima of the x(t-w) coordinate less than the
%bound l in the two-dimensional projection of the attractor given by the
%function MGattractor2D
%T is the time interval on which the solution is integrated
%n is the number of equal steps in the interval [0,tau]
% w is an arbitrary delay to compute a projection 
%Only points with x(t-w) coordinate lower than l are considered
%First the solution is integrate with the function MGsolver 

ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
h=tau/n;          %step length in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the stepsize h
N=T/h;            %number of steps in the interval [0,T]
tspan = linspace(0,T,N);
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(0,T-w, N);  %consider only the last 10% of the solution
solx = deval(sol,tspanx);   %solx is x(t-w)
tspany= linspace(w,T, N);
soly = deval(sol,tspany);   %soly is x(t)
L=length(solx);
X=solx(2:L-1);
Y=solx(1:L-2);
Z=solx(3:L);

indcrit=find( X<Y & X<Z & X<l);    %indeces of the critical points 
crit= X(indcrit);                  %critical points
Mn_1= [];
Mn=[];
Mn_1= crit(1:end-1);
Mn=crit(2:end);

plot(Mn_1, Mn, '.');
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ', \ \tau = ' num2str(tau) ', \ w = ' num2str(w) ', \ T = ' num2str(T) '$'];
title(titolo, 'Interpreter','latex')
axis equal;
xlabel('M_{n-1}');
ylabel('M_n');
grid on;

end
