function MGattractor3Dnotran(alpha,beta,gamma, tau, x0, T, n , w1 , w2, p)
%Plots the three-dimensional projection of the strange attractor corresponding to the given
%parameters alpha,beta,gamma, tau and the constant initial condition (function) x0
%plotting x(t) as a function of x(t-tau)
%T is the imput time
%n is the number of equal steps in the interval [0,tau]
% w1, w2 are arbitrary delays to compute a projection, w1>w2
%p is the last percentage of the solution considered in order to avoid transient behavior
%if p=0.1 then only the last 10% of the solution is considered for the plot
%First the solution is integrate with the function MGsolver 
h=tau/n;          %step size in the interval [0, tau]
T=floor(T/h)*h;   %update of the time T, according to the step size h

N=p*T/h;          %number of steps in the interval [T-p*T,T]
ddefun = @(t, x, x_delayed) MGequation(t, x, x_delayed, alpha,beta,gamma);
delay = tau;
tspan = linspace(0,T+w1+w2,T/h);    %T/h is the number of steps in  [0,T]
sol = dde23(ddefun, delay, x0, tspan);
tspanx= linspace(T-p*T+w2,T-w1, N);
solx = deval(sol,tspanx);             %solx is x(t-w1)
tspany= linspace(T-p*T+w1,T-w2, N);
soly = deval(sol,tspany);             %solx is x(t-w2)
tspanz= linspace(T-p*T+w1+w2,T, N);
solz = deval(sol,tspanz);             %solx is x(t)

plot3(solx, soly, solz, 'LineWidth', 1);
titolo = ['$\alpha = ' num2str(alpha) ', \ \beta = ' num2str(beta) ', \ \gamma = ' num2str(gamma) ',   \ \tau = ' num2str(tau) ' , \ w_1 = ' num2str(w1) ',  \ w_2 = ' num2str(w2) ', \ p = ' num2str(p) ', \ T = ' num2str(T) '$'];
title(titolo, 'Interpreter','latex')
axis equal;
box on;
grid on;
xlabel('x(t-w_1)');
ylabel('x(t-w_2)');
zlabel('x(t)');

end